/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.logging;

import com.aptana.core.logging.Messages;
import com.aptana.core.util.EclipseUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class IdeLog {
    private static Map<Plugin, List<IStatus>> earlyMessageCache = new HashMap<Plugin, List<IStatus>>();
    private static boolean caching = true;
    private static StatusLevel level = StatusLevel.ERROR;

    public static void flushCache() {
        caching = false;
        for (Map.Entry<Plugin, List<IStatus>> entry : earlyMessageCache.entrySet()) {
            for (IStatus status : entry.getValue()) {
                StatusLevel severity = IdeLog.getStatusLevel(status.getSeverity());
                if (status.getSeverity() != 4 && !IdeLog.isOutputEnabled(entry.getKey(), severity, null)) continue;
                IdeLog.log(entry.getKey(), status.getSeverity(), status.getMessage(), null, status.getException());
            }
        }
        earlyMessageCache.clear();
    }

    private IdeLog() {
    }

    public static boolean isSeverityEnabled(StatusLevel debugLevel) {
        if (caching) {
            return true;
        }
        if (level.equals((Object)StatusLevel.OFF)) {
            return false;
        }
        return level.compareTo(debugLevel) >= 0;
    }

    public static StatusLevel getCurrentSeverity() {
        return level;
    }

    public static void setCurrentSeverity(StatusLevel severity) {
        level = severity;
    }

    public static StatusLevel getSeverityPreference() {
        try {
            return Enum.valueOf(StatusLevel.class, Platform.getPreferencesService().getString("com.aptana.core", "pref_debug_level", StatusLevel.ERROR.toString(), null));
        }
        catch (IllegalArgumentException ex) {
            return StatusLevel.ERROR;
        }
    }

    public static boolean isScopeEnabled(String scope) {
        if (scope != null) {
            return EclipseUtil.isDebugOptionEnabled(scope);
        }
        return true;
    }

    public static boolean isErrorEnabled(Plugin plugin, String scope) {
        return IdeLog.isOutputEnabled(plugin, StatusLevel.ERROR, scope);
    }

    public static boolean isWarningEnabled(Plugin plugin, String scope) {
        return IdeLog.isOutputEnabled(plugin, StatusLevel.WARNING, scope);
    }

    public static boolean isInfoEnabled(Plugin plugin, String scope) {
        return IdeLog.isOutputEnabled(plugin, StatusLevel.INFO, scope);
    }

    public static boolean isTraceEnabled(Plugin plugin, String scope) {
        return IdeLog.isSeverityEnabled(StatusLevel.INFO) && Platform.inDebugMode() && IdeLog.isScopeEnabled(scope);
    }

    public static boolean isOutputEnabled(Plugin plugin, StatusLevel severity, String scope) {
        if (!IdeLog.isSeverityEnabled(severity)) {
            return false;
        }
        try {
            if (!Platform.inDebugMode()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return IdeLog.isScopeEnabled(scope);
    }

    private static StatusLevel getStatusLevel(int status) {
        switch (status) {
            case 1: {
                return StatusLevel.INFO;
            }
            case 2: {
                return StatusLevel.WARNING;
            }
            case 4: {
                return StatusLevel.ERROR;
            }
        }
        return StatusLevel.OFF;
    }

    public static void logError(Plugin plugin, String message) {
        IdeLog.logError(plugin, message, null);
    }

    public static void logError(Plugin plugin, Throwable th) {
        IdeLog.logError(plugin, th, null);
    }

    public static void logError(Plugin plugin, Throwable th, String scope) {
        IdeLog.logError(plugin, th.getMessage(), th, scope);
    }

    public static void logError(Plugin plugin, String message, Throwable th) {
        IdeLog.logError(plugin, message, th, null);
    }

    public static void logError(Plugin plugin, String message, String scope) {
        IdeLog.logError(plugin, message, null, scope);
    }

    public static void logError(Plugin plugin, String message, Throwable th, String scope) {
        if (IdeLog.isErrorEnabled(plugin, scope)) {
            IdeLog.log(plugin, 4, message, scope, th);
        } else {
            IdeLog.logTrace(plugin, 4, message, scope, th);
        }
    }

    public static void logWarning(Plugin plugin, String message) {
        IdeLog.logWarning(plugin, message, null);
    }

    public static void logWarning(Plugin plugin, String message, String scope) {
        IdeLog.logWarning(plugin, message, null, scope);
    }

    public static void logWarning(Plugin plugin, Throwable th) {
        IdeLog.logWarning(plugin, th.getMessage(), th);
    }

    public static void logWarning(Plugin plugin, Throwable th, String scope) {
        IdeLog.logWarning(plugin, th.getMessage(), th, scope);
    }

    public static void logWarning(Plugin plugin, String message, Throwable th) {
        IdeLog.logWarning(plugin, message, th, null);
    }

    public static void logWarning(Plugin plugin, String message, Throwable th, String scope) {
        if (IdeLog.isWarningEnabled(plugin, scope)) {
            IdeLog.log(plugin, 2, message, scope, th);
        } else {
            IdeLog.logTrace(plugin, 1, message, scope, th);
        }
    }

    public static void logInfo(Plugin plugin, String message) {
        IdeLog.logInfo(plugin, message, null);
    }

    public static void logInfo(Plugin plugin, String message, String scope) {
        IdeLog.logInfo(plugin, message, null, scope);
    }

    public static void logInfo(Plugin plugin, String message, Throwable th, String scope) {
        if (IdeLog.isInfoEnabled(plugin, scope)) {
            IdeLog.log(plugin, 1, message, scope, th);
        } else {
            IdeLog.logTrace(plugin, 1, message, scope, th);
        }
    }

    public static void logTrace(Plugin plugin, String message) {
        IdeLog.logTrace(plugin, message, null);
    }

    public static void logTrace(Plugin plugin, String message, String scope) {
        IdeLog.logTrace(plugin, message, null, scope);
    }

    public static void logTrace(Plugin plugin, String message, Throwable th, String scope) {
        if (IdeLog.isTraceEnabled(plugin, scope)) {
            IdeLog.log(plugin, 1, message, scope, th);
        } else {
            IdeLog.logTrace(plugin, 1, message, scope, th);
        }
    }

    private static void logTrace(Plugin plugin, int severity, String message, String scope, Throwable th) {
        if (IdeLog.isScopeEnabled("com.aptana.core/debug/logger")) {
            StatusLevel newSeverity = IdeLog.getStatusLevel(severity);
            boolean inSeverity = IdeLog.isSeverityEnabled(newSeverity);
            String cause = "";
            if (!inSeverity) {
                cause = "Not logging items of current severity.";
            } else if (!IdeLog.isScopeEnabled(scope)) {
                cause = "Scope not enabled.";
            }
            String traceMessage = MessageFormat.format("(Build {0}) Skipping log of {1} {2} {3}. Cause: {4}", EclipseUtil.getPluginVersion(plugin), IdeLog.getLabel(severity), scope, message, cause);
            if (plugin != null) {
                Status logStatus = new Status(severity, plugin.getBundle().getSymbolicName(), 0, traceMessage, th);
                plugin.getLog().log((IStatus)logStatus);
            } else {
                System.err.println(traceMessage);
            }
        }
    }

    public static void log(Plugin plugin, IStatus status) {
        IdeLog.log(plugin, status, null);
    }

    public static void log(Plugin plugin, IStatus status, String scope) {
        Throwable th = status.getException();
        if (plugin == null) {
            System.err.println(status.getMessage());
            if (th != null) {
                th.printStackTrace();
            }
            return;
        }
        if (!EclipseUtil.isPluginLoaded(plugin)) {
            System.err.println(status.getMessage());
            return;
        }
        if (caching) {
            List<Object> statusMessages = null;
            if (earlyMessageCache.containsKey(plugin)) {
                statusMessages = earlyMessageCache.get(plugin);
            } else {
                statusMessages = new ArrayList();
                earlyMessageCache.put(plugin, statusMessages);
            }
            statusMessages.add(status);
        } else {
            plugin.getLog().log(status);
        }
        if (status.getSeverity() == 4 && IdeLog.isOutputEnabled(plugin, StatusLevel.ERROR, scope)) {
            System.err.println(status.getMessage());
            if (th != null) {
                th.printStackTrace();
            }
        }
    }

    public static void log(Plugin plugin, int severity, String message, String scope, Throwable th) {
        String tempMessage = IdeLog.buildMessage(plugin, severity, message, scope, th);
        String symbolicName = "com.aptana.core";
        if (plugin != null && plugin.getBundle() != null) {
            symbolicName = plugin.getBundle().getSymbolicName();
        }
        Status logStatus = new Status(severity, symbolicName, 0, tempMessage, th);
        IdeLog.log(plugin, (IStatus)logStatus, scope);
    }

    public static String buildMessage(Plugin plugin, int severity, String message, String scope, Throwable th) {
        if (scope == null) {
            scope = "";
        }
        String version = EclipseUtil.isStandalone() ? EclipseUtil.getProductVersion() : EclipseUtil.getStudioVersion();
        return MessageFormat.format("(Build {0}) {1} {2} {3}", version, IdeLog.getLabel(severity), scope, message);
    }

    private static String getLabel(int status) {
        switch (status) {
            case 1: {
                return Messages.IdeLog_INFO;
            }
            case 2: {
                return Messages.IdeLog_WARNING;
            }
            case 4: {
                return Messages.IdeLog_ERROR;
            }
        }
        return Messages.IdeLog_UNKNOWN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusLevel {
        ERROR,
        WARNING,
        INFO,
        OFF;

    }
}

